﻿using System;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using Microsoft.PowerShell.Host.ISE;


namespace BartISEAddOn
{
    /// <summary>
    /// Interaction logic for UserControl1.xaml
    /// </summary>
    public partial class FirstAddon : UserControl, IAddOnToolHostObject
    {
        ObjectModelRoot hostObject;
        public ObjectModelRoot HostObject
        {
            get
            {
                return this.hostObject;
            }
            set
            {
                this.hostObject = value;
            }
        }
        public FirstAddon()
        {
            this.InitializeComponent();
        }

        private void Przywroc_Click(object sender, RoutedEventArgs e)
        {
            if (Lista.Items.Count == 0)
            {
                return;
            }
            if (Lista.SelectedItems.Count != 1)
            {
                MessageBox.Show(
                    "Musisz wybrać dokładnie jeden obiekt z listy!",
                    "Błąd: zły wybór",
                    MessageBoxButton.OK,
                    MessageBoxImage.Error
                );
                return;
            }
            var wybor = Lista.SelectedItem;
            Tekst.Text = wybor.ToString();
        }

        private void Wstaw_Click(object sender, RoutedEventArgs e)
        {
            if (HostObject.CurrentPowerShellTab.Files.Count == 0)
            {
                return;
            }
            try
            {
                Lista.Items.Add(Tekst.Text);
                if (Lista.Visibility == Visibility.Collapsed)
                {
                    Lista.Visibility = Visibility.Visible;
                }
                HostObject
                    .CurrentPowerShellTab
                    .Files
                    .SelectedFile
                    .Editor
                    .Text += Tekst.Text;
            }
            catch
            {
                MessageBox.Show(
                    "Błąd typu błąd! Nie mam pojęcia co skrewiłem... :|",
                    "Auć...",
                    MessageBoxButton.OK,
                    MessageBoxImage.Error
                );
            }
            return;

        }
    }
}
